<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ProductController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');
//guest middleware 
Route::post('login', [AuthController::class, 'login']);
Route::post('register', [AuthController::class, 'register']);

Route::middleware('auth:sanctum')->group(function () {

    Route::post('logout', [AuthController::class, 'logout']);

    // Route::get('products', [ProductController::class, 'index']); // Get all products
    Route::post('study', [AuthController::class, 'logout']); // Get all products

    //products 
   
   
   
});
 Route::put('product/{id}', [ProductController::class, 'update']); // Update product

 Route::post('products', [ProductController::class, 'store']); // Create new product

 Route::delete('product/{id}', [ProductController::class, 'destroy']); // Delete product

Route::get('products', [ProductController::class, 'index']); // Get all products