<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;

class ProductController extends Controller
{

    public function index(){
        $products = Product::all();
        return response()->json($products);
    }

    public function store(Request $request){

        $field = $request->all();
        Product::create($field);
        return response()->json(['message'=>'Product created successfully']);
    }

    public function update(Request $request,$id){

        $product = Product::find($id);
        if(!$product){
            return response()->json(['message'=>'Product not found'],404);
        }
        $field = $request->all();
        $product ->update($field);
        return response()->json(['message'=>'Product updated successfully']);
        
        }
        
        public function destroy($id){

            $product = Product::find($id);
            if(!$product){
                return response()->json(['message'=>'Product not found'],404);
            }
            $product ->delete();
            return response()->json(['message'=>'Product delete successfully']);
        }



    


}
